<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Model_Moderate
{
    const TYPE_LINK = 'Using links inside message';
    const TYPE_KEYWORD = 'Using disallowed keywords inside message';
    const TYPE_AKISMET = 'Found in Akismet database';
    const TYPE_REGISTER = 'Either Found in Spam Database Service or Reach Point Limitation Rule';
    
    public static function getReason(array $reason)
    {
        switch ($reason['type'])
        {
            case sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK:
                return self::TYPE_LINK;
                break;
            case sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD:
                return self::TYPE_KEYWORD;
                break;
            case sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET:
                return self::TYPE_AKISMET;
                break;
            case sonnbStopSpamHere_Model_SSH::LOG_TYPE_REGISTER:
                return self::TYPE_REGISTER;
                break;
        }
    }
    
    public static function sendPC($visitor, $url, $reason)
    {
        $xenOptions = XenForo_Application::getOptions();
        $senderUserId = $xenOptions->sonnbStopSpamHere_pc_sender;
        $receiptUserIds = explode(',',$xenOptions->sonnbStopSpamHere_pc_receipt);
        
        if ($senderUserId && !empty($receiptUserIds))
        {
            $senderUser = XenForo_Model_DataRegistry::create('XenForo_Model_User')->getUserById($senderUserId);
            
            $message = new XenForo_Phrase(
                    'sonnbStopSpamHere_phrase_pc', 
                    array(
                        'poster_link' => XenForo_Template_Helper_Core::helperUserName($visitor->toArray(), '', true),
                        'url' => $url,
                        'reason' => self::getReason($reason)
                    )
                );
            
            $message = htmlspecialchars_decode($message->render());
            $options = array();
            $requestPaths = XenForo_Application::get('requestPaths');
            $options['baseUrl'] = $requestPaths['fullBasePath'];
            
            $message = XenForo_Html_Renderer_BbCode::renderFromHtml($message, $options);
            
            $title = new XenForo_Phrase('sonnbStopSpamHere_phrase_pc_title');
            $title = $title->render();
            
            $conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
            $conversationDw->set('user_id', $senderUser['user_id']);
            $conversationDw->set('username', $senderUser['username']);
            $conversationDw->set('title', $title);
            $conversationDw->addRecipientUserIds($receiptUserIds);
            
            $messageDw = $conversationDw->getFirstMessageDw();
            $messageDw->set('message', $message);
            
            $conversationDw->preSave();
            $conversationDw->save();
        }
    }
    
    public static function sendReport($type, $data, $reason)
    {
        $visitor = XenForo_Visitor::getInstance();
        $xenOptions = XenForo_Application::getOptions();
        $senderUserId = $xenOptions->sonnbStopSpamHere_report_userid;
        
        $senderUser = ($senderUserId ? XenForo_Model_DataRegistry::create('XenForo_Model_User')->getUserById($senderUserId):$visitor->toArray());  
        
        $message = new XenForo_Phrase(
                'sonnbStopSpamHere_phrase_report', 
                array(
                    'username' => $visitor['username'],
                    'reason' => self::getReason($reason)
                )
            );

        $message = $message->render();

        $reportModel = XenForo_Model_DataRegistry::create('XenForo_Model_Report');
        $reportModel->reportContent($type, $data, $message, $senderUser);
    }
}

?>
